	clear all
	close all
	clc
	
	%	Cauer filter
	% Requirement for the bandpass filter
	wc1 = 25; wc2 = 32; ws1 = 12; ws2 = 60;
 	Amax = 0.28029; Amin = 60;
	if wc1*wc2 <= ws1*ws2;				% Modify band edges if needed
		ws2 = wc1*wc2/ws1
	else
		ws1 = wc1*wc2/ws2
	end
	% Requirements for lowpass filter
	Omegac = wc2 - wc1
	Omegas = ws2 - ws1
	wI2 = wc1*wc2 
	% Synthesis of lowpass filter (Cauer)	
	NLP = CA_ORDER_S(Omegac, Omegas, Amax, Amin)
	NLP = 3;	% Re-run after seting the filter order
	[GLP, ZLP, R_ZEROS, PLP, Wsnew] = CA_POLES_S(Omegac, Omegas, Amax, Amin, NLP)
	figure(1)
	PLOT_PZ_S(ZLP, PLP, Omegac, Omegas, -40, 10, 60)
	
	% Transform the lowpass to a bandpass filter
	[Gbp, Zbp, Pbp] = PZ_2_G_SYM_BP_S(GLP, ZLP, PLP, wI2)
	figure(2)
	PLOT_PZ_S(Zbp, Pbp, 0,0, -10, 10, 100);
	
%	alfa = linspace(pi/2, 3*pi/2, 200);
%%	plot(0.5*Omegas*cos(alfa), 0.5*Omegas*sin(alfa)+sqrt(wI2),'-','linewidth', 1);
%	plot(0.5*Omegac*cos(alfa), 0.5*Omegac*sin(alfa)+sqrt(wI2),'-','linewidth', 1);
%	plot(0.5*Omegas*cos(alfa), 0.5*Omegas*sin(alfa)-sqrt(wI2),'-','linewidth', 1);
%	plot(0.5*Omegac*cos(alfa), 0.5*Omegac*sin(alfa)-sqrt(wI2),'-','linewidth', 1);
	N = 2*NLP;					% BP filter has the order 2*NLP
	W = [0:0.01:100];
	H = PZ_2_FREQ_S(Gbp, Zbp, Pbp, W);
	Att = MAG_2_ATT(H);
	
%	figure(3)
	subplot('position', [0.08 0.4 0.90 0.5]);
	plot(W, Att,'linewidth',2);
	color = [0.7 0.7 0.7]; % Gray
	V = axis;
	patch([wc1 wc2  wc2 wc1], [Amax Amax V(4) V(4)], color);
	patch([0 5  5 0], [0 0 Amin Amin], color);
	patch([ws2 V(2)  V(2) ws2], [0 0 Amin Amin], color);
	zoom on
	axis([0 100 0 80]);
	
	figure(4)
	Taug = PZ_2_TG_S(Gbp, Zbp, Pbp, W);
	subplot('position', [0.08 0.4 0.80 0.5]);
	axis_Amax = 80; axis_Tg_max = 1.6;	
	PLOT_ATT_TG_S(Att, Taug, W, axis_Amax, axis_Tg_max); 
			fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	
		text(60, 1,'Attenuation','FontName',fn,'FontSize',fs);
text(20, 1.2,'Group Delay','FontName',fn,'FontSize',fs);
	
